﻿from microcontroleurs import arduino
import matplotlib.pyplot as plt
import numpy as np

#creation de la commuication avec la carte arduino
#le numero du port COM est à modifier
macarte = arduino("COM3")

#crée deux listes vides pour mettre les mesures
p = []
volume = []

#demande à l'utilisateur le nb de points de mesure
nb_points=int(input("Entrez le nombre de points de mesure :"))

#remplit les listes avec les valeurs
for i in range(nb_points):
    #ajoute V dans la liste où V est entré par l'utilisateur
    volume.append(int(input("Entrez le volume V en mL :")))
    #ajoute P mesuree par le capteur à la liste
    tension=macarte.entree_analogique(0) * 5 / 1023
    p.append(round(tension / 0.0006429 - 311,1))

#arrêt de la communication avec la carte arduino
macarte.fermer()
print(p)
print(volume)

# trace les points expérimentaux
plt.scatter(p,volume, marker='o', color='blue' , label = "Points expérimentaux")   # points bleus

plt.axis()
plt.title("Volume = f(p)")
plt.xlabel("p (hPa)")
plt.ylabel("Volume (mL)")
plt.legend(loc ="upper right")
plt.show()



